/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.MarkedObject;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Section;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

public class MarkedSection
extends MarkedObject {
    protected MarkedObject title = null;

    public MarkedSection(Section section) {
        if (section.title != null) {
            this.title = new MarkedObject(section.title);
            section.setTitle(null);
        }
        this.element = section;
    }

    public void add(int index, Object o) {
        ((Section)this.element).add(index, o);
    }

    public boolean add(Object o) {
        return ((Section)this.element).add(o);
    }

    public boolean process(ElementListener listener) {
        try {
            Iterator i = ((Section)this.element).iterator();
            while (i.hasNext()) {
                Element element = (Element)i.next();
                listener.add(element);
            }
            return true;
        }
        catch (DocumentException de) {
            return false;
        }
    }

    public boolean addAll(Collection collection) {
        return ((Section)this.element).addAll(collection);
    }

    public MarkedSection addSection(float indentation, int numberDepth) {
        MarkedSection section = ((Section)this.element).addMarkedSection();
        section.setIndentation(indentation);
        section.setNumberDepth(numberDepth);
        return section;
    }

    public MarkedSection addSection(float indentation) {
        MarkedSection section = ((Section)this.element).addMarkedSection();
        section.setIndentation(indentation);
        return section;
    }

    public MarkedSection addSection(int numberDepth) {
        MarkedSection section = ((Section)this.element).addMarkedSection();
        section.setNumberDepth(numberDepth);
        return section;
    }

    public MarkedSection addSection() {
        return ((Section)this.element).addMarkedSection();
    }

    public void set(Properties attributes) {
        ((Section)this.element).set(attributes);
    }

    public void setTitle(MarkedObject title) {
        if (title.element instanceof Paragraph) {
            this.title = title;
        }
    }

    public MarkedObject title() {
        if (this.title == null) {
            return null;
        }
        int depth = Math.min(((Section)this.element).numbers.size(), ((Section)this.element).numberDepth);
        if (depth < 1) {
            return this.title;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < depth) {
            buf.insert(0, ".");
            buf.insert(0, (Integer)((Section)this.element).numbers.get(i));
            ++i;
        }
        if (buf.length() > 0) {
            buf.append(" ");
        }
        Paragraph result = new Paragraph((Paragraph)this.title.element);
        result.add(0, new Chunk(buf.toString(), ((Paragraph)this.title.element).font()));
        MarkedObject mo = new MarkedObject(result);
        mo.markupAttributes = this.title.markupAttributes;
        return mo;
    }

    public void setNumberDepth(int numberDepth) {
        ((Section)this.element).setNumberDepth(numberDepth);
    }

    public void setIndentationLeft(float indentation) {
        ((Section)this.element).setIndentationLeft(indentation);
    }

    public void setIndentationRight(float indentation) {
        ((Section)this.element).setIndentationRight(indentation);
    }

    public void setIndentation(float indentation) {
        ((Section)this.element).setIndentation(indentation);
    }

    public void setBookmarkOpen(boolean bookmarkOpen) {
        ((Section)this.element).setBookmarkOpen(bookmarkOpen);
    }

    public void setTriggerNewPage(boolean triggerNewPage) {
        ((Section)this.element).setTriggerNewPage(triggerNewPage);
    }

    public void setBookmarkTitle(String bookmarkTitle) {
        ((Section)this.element).setBookmarkTitle(bookmarkTitle);
    }
}

