/*
 * Decompiled with CFR 0.152.
 */
package com.jansensystems.pdfspicer;

import com.lowagie.text.pdf.PdfReader;
import java.io.File;
import java.io.FileInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFFile
implements Comparable<PDFFile> {
    private File file;
    private int pages = 0;

    public PDFFile(File f) throws Exception {
        this.file = f;
        PdfReader reader = null;
        try {
            reader = new PdfReader(new FileInputStream(f));
            this.pages = reader.getNumberOfPages();
            reader.close();
        }
        catch (Exception e) {
            System.out.println(e);
            throw new Exception("Could not open PDF file!");
        }
    }

    public File getFile() {
        return this.file;
    }

    public int getPages() {
        return this.pages;
    }

    public long getFileSize() {
        return this.file.length() / 1024L;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PDFFile)) {
            return false;
        }
        return ((PDFFile)o).getFile().compareTo(this.getFile()) == 0;
    }

    public int hashCode() {
        int hash = 3;
        hash = 73 * hash + (this.file != null ? this.file.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(PDFFile o) {
        return o.getFile().compareTo(this.getFile());
    }
}

